/*
 * Decompiled with CFR 0.152.
 */
package jace.config;

import jace.config.ISelection;
import jace.core.Utility;
import java.util.Iterator;
import java.util.LinkedHashMap;

public abstract class DynamicSelection<T>
implements ISelection<T> {
    T currentValue;

    public DynamicSelection(T defaultValue) {
        this.setValue(defaultValue);
    }

    public abstract boolean allowNull();

    @Override
    public T getValue() {
        if (this.currentValue != null || !this.allowNull()) {
            return this.currentValue;
        }
        Iterator i = this.getSelections().keySet().iterator();
        return i.next();
    }

    @Override
    public void setValue(T value) {
        this.currentValue = value;
    }

    @Override
    public void setValueByMatch(String search) {
        LinkedHashMap selections = this.getSelections();
        String match = Utility.findBestMatch(search, selections.values());
        if (match != null) {
            for (Object key : selections.keySet()) {
                if (!((String)selections.get(key)).equals(match)) continue;
                this.setValue(key);
                return;
            }
        } else {
            this.setValue(null);
        }
    }
}

